//=============================================================================
// Grappling gun :P
//=============================================================================
class MSGrapplingGun extends DeusExWeapon;

var Actor Hooked;

state NormalFire
{
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;


				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();

	ReadyToFire();
Done:
	bFiring = False;
	Finish();
}

Function CycleAmmo()
{
  local GrapplingHook Hook;

    ForEach AllActors(class'GrapplingHook',Hook)
    {
    if ((Hook != None) && (Hook.Owner == Owner)) 
      {
        Hook.Destroy();
      }
    }
//    DeusExPlayer(Owner).StartWalk();
}

Function LaserToggle()
{
  local GrapplingHook Hook;

    ForEach AllActors(class'GrapplingHook',Hook)
    {
    if ((Hook != None) && (Hook.Owner == Owner)) 
      {
        if (Hook.IsInState('Grappling2'))
        {
        }
        else
        {
         Pawn(Owner).SetPhysics(PHYS_Falling);
         Pawn(Owner).Velocity = Hook.Speed * vector(Hook.Rotation + rot(-33320,0,0));
        }
      }
    }
}

Function ScopeToggle()
{
  local GrapplingHook Hook;

    ForEach AllActors(class'GrapplingHook',Hook)
    {
    if ((Hook != None) && (Hook.Owner == Owner)) 
      {
        if (Hook.IsInState('Grappling2'))
        {
         Hook.Velocity = Hook.Speed * vector(Hook.Rotation + rot(-33320,0,0) * (Hooked.Mass / 10));
        }
        else
        {
         Pawn(Owner).SetPhysics(PHYS_Falling);
         Pawn(Owner).Velocity = Hook.Speed * vector(Hook.Rotation) + (vector(Hook.Rotation) * 0.35);
        }
      }
    }
}

defaultproperties
{
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=0.000000
     reloadTime=0.000001
     HitDamage=300
     maxRange=24000
     AccurateRange=14400
     BaseAccuracy=0.000000
     bCanHaveScope=True
     bHasScope=True
     bHasMuzzleFlash=False
     recoilStrength=1.000000
     bEmitWeaponDrawn=False
     bUseWhileCrouched=False
     mpHitDamage=40
     mpAccurateRange=14400
     mpMaxRange=14400
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     PickupAmmoCount=10
     bInstantHit=False
     bWeaponStay=True
     FireOffset=(X=-25.000000,Y=8.000000,Z=14.000000)
     ProjectileClass=Class'MSGrappling1_1.GrapplingHook'
     shakemag=30.000000
     FireSound=Sound'DeusExSounds.Weapons.MiniCrossbowFire'
     AltFireSound=Sound'DeusExSounds.Weapons.MiniCrossbowReloadEnd'
     CockingSound=Sound'DeusExSounds.Weapons.MiniCrossbowReload'
     SelectSound=Sound'DeusExSounds.Weapons.MiniCrossbowSelect'
     InventoryGroup=250
     PickupMessage="|p4Use your change ammo button to end grappling and you scope and laser toggle buttons to contract and extend the line. |p1You have obtained"
     ItemName="|cf88Markistan Corp Grappling Gun"
     ItemArticle="|p1a"
     PlayerViewOffset=(X=25.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'DeusExItems.MiniCrossbow'
     PickupViewMesh=LodMesh'DeusExItems.MiniCrossbowPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.MiniCrossbow3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconCrossbow'
     largeIcon=Texture'DeusExUI.Icons.LargeIconCrossbow'
     largeIconWidth=47
     largeIconHeight=46
     invSlotsX=4
     Description="A grappling hook gun suggested by (RA)Snipes and inspired by Jim Bowen's grappling gun."
     beltDescription="|cf88 GRAPPLE"
     Mesh=LodMesh'DeusExItems.MiniCrossbowPickup'
     CollisionRadius=20.000000
     CollisionHeight=2.500000
     ThirdPersonScale=2.500000
     PickupViewScale=2.500000
     DrawScale=2.500000
     Mass=30.000000
}
